/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core.forge;

import icyllis.modernui.ModernUI;
import icyllis.modernui.core.forge.Config;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

final class ServerHandler {
    static final ServerHandler INSTANCE = new ServerHandler();
    boolean started = false;
    private long shutdownTime = 0L;
    private long nextShutdownNotify = 0L;
    private final long[] shutdownNotifyTimes = new long[]{1000L, 2000L, 3000L, 4000L, 5000L, 6000L, 7000L, 8000L, 9000L, 10000L, 60000L, 300000L, 600000L, 1800000L};

    ServerHandler() {
    }

    @SubscribeEvent
    void onStart(@Nonnull FMLServerStartedEvent event) {
        this.started = true;
        this.determineShutdownTime();
    }

    @SubscribeEvent
    void onStop(@Nonnull FMLServerStoppingEvent event) {
        this.started = false;
    }

    void determineShutdownTime() {
        if (!this.started) {
            return;
        }
        if (((Boolean)Config.COMMON.autoShutdown.get()).booleanValue()) {
            Calendar calendar = Calendar.getInstance();
            int current = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
            int target = Integer.MAX_VALUE;
            for (String s2 : (List)Config.COMMON.shutdownTimes.get()) {
                try {
                    String[] s1 = s2.split(":", 2);
                    int h2 = Integer.parseInt(s1[0]);
                    int m3 = Integer.parseInt(s1[1]);
                    if (h2 >= 0 && h2 < 24 && m3 >= 0 && m3 < 60) {
                        int t = h2 * 3600 + m3 * 60;
                        if (t < current) {
                            t += 86400;
                        }
                        target = Math.min(t, target);
                        continue;
                    }
                    ModernUI.LOGGER.warn(ModernUI.MARKER, "Wrong time format while setting auto-shutdown time, input: {}", (Object)s2);
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    ModernUI.LOGGER.error(ModernUI.MARKER, "Wrong time format while setting auto-shutdown time, input: {}", (Object)s2, (Object)e);
                }
            }
            if (target < Integer.MAX_VALUE && target > current) {
                this.shutdownTime = System.currentTimeMillis() + (long)(target - current) * 1000L;
                ModernUI.LOGGER.debug(ModernUI.MARKER, "Server will shutdown at {}", (Object)SimpleDateFormat.getDateTimeInstance().format(new Date(this.shutdownTime)));
                this.nextShutdownNotify = this.shutdownNotifyTimes[this.shutdownNotifyTimes.length - 1];
            } else {
                this.shutdownTime = 0L;
            }
        } else {
            this.shutdownTime = 0L;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    void onLastEndTick(@Nonnull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.shutdownTime > 0L) {
            long countdown = this.shutdownTime - System.currentTimeMillis();
            this.sendShutdownNotification(countdown);
            if (countdown <= 0L) {
                ServerLifecycleHooks.getCurrentServer().func_71263_m(false);
            }
        }
    }

    private void sendShutdownNotification(long countdown) {
        if (countdown < this.nextShutdownNotify) {
            String str;
            String key;
            do {
                int index;
                if ((index = Arrays.binarySearch(this.shutdownNotifyTimes, this.nextShutdownNotify)) <= 0) {
                    this.nextShutdownNotify = 0L;
                    break;
                }
                this.nextShutdownNotify = this.shutdownNotifyTimes[index - 1];
            } while (countdown < this.nextShutdownNotify);
            long l = Math.round((double)countdown / 1000.0);
            if (l > 60L) {
                l = Math.round((double)l / 60.0);
                key = "message.modernui.server_shutdown_min";
                str = "Server will shutdown in %d minutes";
            } else {
                key = "message.modernui.server_shutdown_sec";
                str = "Server will shutdown in %d seconds";
            }
            ModernUI.LOGGER.info(ModernUI.MARKER, String.format(str, l));
            IFormattableTextComponent component = new TranslationTextComponent(key, new Object[]{l}).func_240699_a_(TextFormatting.LIGHT_PURPLE);
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v().forEach(arg_0 -> ServerHandler.lambda$sendShutdownNotification$0((ITextComponent)component, arg_0));
        }
    }

    private static /* synthetic */ void lambda$sendShutdownNotification$0(ITextComponent component, ServerPlayerEntity p) {
        p.func_146105_b(component, true);
    }
}

